 ; Ŀ
 ;   Trayhach - hatch a cable tray.  And classify other things.            
 ;   Copyright 1996, 1997, 1999, 2002, 2010 by Rocket Software Ltd.        
 ;   As Marshall McLuhan said, "The medium is the message."                
 ;   If on the other hand you are ordering a moderately well cooked steak  
 ;   the message is "medium".                                              
 ; 

 ; Ŀ
 ;   Subroutine Thrash - does the real work.                               
 ; 
 (DEFUN THRASH (patnam laynam laycol scal / *error* hscal)
  (setvar "cmdecho" 0)
  (command "undo" "M")
 ; Ŀ
 ;   Make an error handler.                                                
 ; 
  (DEFUN *ERROR* (shk /)
   (if clay (setvar "clayer" clay))
  (princ))
 ; Ŀ
 ;   Load Misps.lsp, which contains the ps/ms scaling subroutines.         
 ; 
  (if (or (null wasp) (null misps))
      (if (null (load "misps" ()))
          (prompt "\n** The File Misps.lsp Is Not Available. **\n")))
 ; Ŀ
 ;   Get the scale, depending on which space we are in and other things.   
 ; 
  (if misps
      (setq dimscl (misps))
      (setq dimscl (getvar "dimscale")))
  (setq hscal (* scal dimscl))
 ; Ŀ
 ;   Get the pattern name and scale.                                       
 ; 
  (setvar "hpname" patnam)
  (setvar "hpscale" hscal)
  (setq clay (getvar "clayer"))
  (if (tblsearch "layer" laynam)
      (setvar "clayer" laynam)
      (command "layer" "m" laynam
                       "c" laycol laynam
                       "ltype" "continuous" laynam ""))
  (if (type c:bhatch) ; release 12/14 selector
      (c:bhatch)
      (command "bhatch"))
 (princ))
 ; Ŀ
 ;   Thrash end.                                                           
 ; 

 ; Ŀ
 ;   Trayhach - draw a dot hatch.                                          
 ; 
 (DEFUN C:TRAYHACH (/ hscal)
  (thrash "dots" "Cable_Tray" "62" 25)
 (princ))

 ; Ŀ
 ;   Ansi31 - draw an Ansi31 hatch.                                        
 ; 
 (DEFUN C:ANSI31 (/ hscal)
  (thrash "ansi31" "hatch" "6" 16)
 (princ))

 ; Ŀ
 ;   Ansi37 - draw an Ansi37 (crosshatch?) hatch.                          
 ; 
 (DEFUN C:ANSI37 (/ hscal)
  (thrash "ansi37" "hatch" "6" 16)
 (princ))

 ; Ŀ
 ;   Bhex - draw a Hex hatch.                                              
 ; 
 (DEFUN C:BHEX (/ hscal)
  (thrash "hex" "hatch" "6" 4)
 (princ))

(princ)